/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.impl;

import com.cisco.pt.IPAddress;
import com.cisco.pt.impl.LTVParsingError;
import java.util.Arrays;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IPAddressImpl
implements IPAddress {
    private static Log logger = LogFactory.getLog(IPAddressImpl.class);
    public static final int IPADDRESS_BYTES = 4;
    byte[] bytes = new byte[4];

    public IPAddressImpl(byte byte1, byte byte2, byte byte3, byte byte4) {
        this.bytes[0] = byte1;
        this.bytes[1] = byte2;
        this.bytes[2] = byte3;
        this.bytes[3] = byte4;
    }

    public IPAddressImpl(byte[] newBytes) {
        this.setBytes(newBytes);
    }

    public IPAddressImpl(String ipStr) throws NumberFormatException {
        String[] byteStrings = ipStr.split("\\.");
        if (byteStrings.length != 4) {
            logger.error((Object)("Invalid format for IP Address: " + ipStr));
            throw new NumberFormatException("Invalid format for IP Address: " + ipStr);
        }
        try {
            for (int index = 0; index < 4; ++index) {
                int quad = Integer.parseInt(byteStrings[index]);
                this.bytes[index] = (byte)(quad & 0xFF);
            }
        }
        catch (NumberFormatException nfe) {
            logger.error((Object)("Invalid format for IP Address: " + ipStr));
            throw (NumberFormatException)new NumberFormatException("Invalid format for IP Address: " + ipStr).initCause(nfe);
        }
    }

    protected void setBytes(byte[] newBytes) {
        Arrays.fill(this.bytes, (byte)0);
        int offset = newBytes.length >= this.bytes.length ? 0 : this.bytes.length - newBytes.length;
        int limit = Math.min(this.bytes.length, newBytes.length);
        for (int i = 0; i < limit; ++i) {
            this.bytes[offset + i] = newBytes[i];
        }
    }

    public String toString() {
        return this.getDottedQuadString();
    }

    public String getDottedQuadString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            if (i > 0) {
                builder.append('.');
            }
            int quad = this.bytes[i] & 0xFF;
            builder.append(quad);
        }
        return builder.toString();
    }

    public String getHexString() {
        char[] chars = Hex.encodeHex((byte[])this.bytes);
        return new String(chars);
    }

    public byte[] getByteArrayValue() {
        return this.bytes;
    }

    public int getIntValue() {
        int answer = 0;
        for (int i = 0; i < 4; ++i) {
            answer <<= 8;
            answer |= this.bytes[i] & 0xFF;
        }
        return answer;
    }

    protected String toHex(byte byteValue) {
        String answer = Integer.toHexString(byteValue);
        if (answer.length() == 1) {
            return "0" + answer;
        }
        return answer;
    }

    public static IPAddress parseIPAddress(String s) {
        IPAddressImpl ipAddr = null;
        int[] quads = new int[4];
        String[] byteStrings = s.split("\\.");
        if (byteStrings.length != 4) {
            throw new LTVParsingError("Invalid format for IP Address: " + s);
        }
        try {
            for (int index = 0; index < 4; ++index) {
                quads[index] = Integer.parseInt(byteStrings[index]);
            }
            ipAddr = new IPAddressImpl((byte)quads[0], (byte)quads[1], (byte)quads[2], (byte)quads[3]);
        }
        catch (NumberFormatException nfe) {
            throw new LTVParsingError("Invalid format for IP Address: " + s);
        }
        return ipAddr;
    }
}

